#ifndef __EGUI__
#define __EGUI__

/**
 * @file EGUI.h
 * @brief Single include for the GUI package
 *
 * @date 23/08/2004
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk\n
 * All content is the Intellectual property of Exp Digital Uk.\n
 * Certain sections of this code may come from other sources. They are credited where applicable.\n
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * $Id: EGUI.h,v 1.7 2007/02/11 02:16:22 paul Exp $
 */

/**
 * @namespace Exponent::GUI
 * @brief Main UI handling namespace
 *
 * Contains all graphics handling routines
 */

// Uncomment to debug clipping whilst drawing
//#define DEBUG_CLIPPING

#include "Basics/GUIBasics.h"
#include "Controls/Controls.h"
#include "Events/Events.h"
#include "Fonts/FontsInclude.h"
#include "Graphics/GraphicsInclude.h"
#include "Listeners/Listeners.h"
#include "Windowing/Windowing.h"

//	===========================================================================

#ifndef EXPONENT_COMPACT_BUILD
	using namespace Exponent::GUI;
#endif

#endif	// End of GUI.h